package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.enums;

import lombok.Getter;

/**
 * 消费者性别类型枚举
 *
 * @author zouwx
 * @date 2022/05/06
 */
@Getter
public enum ConsumerSexTypeEnum {
    /**
     * 客户性别类型
     */
    MAN(1, "男"),
    WOMAN(2, "女"),
    ;


    private Integer value;

    private String desc;

    ConsumerSexTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (ConsumerSexTypeEnum item : ConsumerSexTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static ConsumerSexTypeEnum valueOf(Integer value) {
        for (ConsumerSexTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public static ConsumerSexTypeEnum valueOfDesc(String desc) {
        for (ConsumerSexTypeEnum param : values()) {
            if (param.getDesc().equals(desc)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
