package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.enums;

import lombok.Getter;

/**
 * 冻结状态枚举
 *
 * @author zouwx
 * @date 2022/05/19
 */
@Getter
public enum FreezeStatusEnum {


    /**
     * 冻结状态枚举
     */
    NOT_FREEZE(1, "非冻结"),
    FREEZE(2, "冻结"),
    ;


    private Integer value;

    private String desc;

    FreezeStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (FreezeStatusEnum item : FreezeStatusEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static FreezeStatusEnum valueOf(Integer value) {
        for (FreezeStatusEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
