package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/28 3:20 下午
 **/
@Data
public class ConsumerAddParam implements Serializable {
    private static final long serialVersionUID = 7497894627785082636L;
    /**
     * 应用id
     */
    @NotNull(message = "appId不能为空")
    private String appId;

    /**
     * 积分
     */
    @NotNull(message = "credits不能为空")
    private Long credits;

    /**
     * 开发者端用户ID
     */
    @NotNull(message = "partnerUserId不能为空")
    private String partnerUserId;

    /**
     * VIP等级map， JSON
     */
    private String vipGroup;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 是否新用户
     */
    private Boolean newUser;

    /**
     * 是否关注公众号
     */
    private Boolean followWx;

    /**
     * 用户拓展信息
     */
    private ConsumerExtraAddParam consumerExtraAddParam;

    /**
     * 标记列表
     */
    private List<Long> tagList;

    /**
     * 未登录用户
     */
    private Boolean notLoginUser;
}
