package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param;

import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.enums.CreditAccountTypeEnum;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.enums.CreditChangeTypeEnum;
import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/28 12:05 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class CreditAccountFlowQueryParam extends PageRequest {

    private static final long serialVersionUID = -7415691628967086319L;
    /**
     * cid
     */
    @NotNull(message = "cid不能为空")
    private Long cid;


    /**
     * 变更类型
     *
     * @see CreditChangeTypeEnum
     */
    private Integer changeType;

    /**
     * 账户类型
     *
     * @see CreditAccountTypeEnum
     */
    private Integer accountType;

    /**
     * 业务编号
     */
    private String bizNo;

    /**
     * 开始时间
     */
    private Date startDate;

    /**
     * 结束数据
     */
    private Date endDate;
}
