package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param;

import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.enums.CreditChangeTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 积分操作
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/30 2:52 下午
 **/
@Data
public class CreditOptParam implements Serializable {
    private static final long serialVersionUID = -695597748724651395L;
    @NotNull(message = "cid不能为空")
    private Long cid;

    /**
     * 正数+
     * 负数-
     */
    @NotNull(message = "积分不能为空")
    private Long credit;

    /**
     * 业务编号，用于幂等处理
     * 注意：底层没存，幂等效果1小时内
     */
    @NotNull(message = "业务编号不能为空")
    private String bizNo;

    /**
     * 积分变更类型
     *
     * @see CreditChangeTypeEnum
     */
    private Integer changeType;

    /**
     * 说明
     */
    private String memo;
}
