package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.ConsumerGrowthValueDTO;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.ConsumerGrowthValueQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @author zhengjianhao
 * @date 2022/6/13
 * @description
 */
@AdvancedFeignClient
public interface RemoteConsumerGrowthValueService {

	/**
	 * 根据用户id查询
	 */
	ConsumerGrowthValueDTO getByCid(Long cid);

	/**
	 * 新增
	 */
	void add(ConsumerGrowthValueDTO dto) throws BizException;

	/**
	 * 更新
	 */
	void update(ConsumerGrowthValueDTO dto) throws BizException;

	/**
	 * 根据条件分页查询
	 */
	PageResponse<ConsumerGrowthValueDTO> pageQuery(ConsumerGrowthValueQueryParam param) throws BizException;

}
