package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.ConsumerWechatDTO;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.ConsumerWechatAddParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.ConsumerWechatQueryParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.ConsumerWechatUpdateParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 用户微信服务
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/28 2:29 下午
 **/
@AdvancedFeignClient
public interface RemoteConsumerWechatService {
    /**
     * 查询用户微信
     *
     * @param param
     * @return
     */
    PageResponse<ConsumerWechatDTO> queryForPage(ConsumerWechatQueryParam param);

    /**
     * 添加用户微信
     *
     * @param param
     * @return
     */
    Boolean addOne(ConsumerWechatAddParam param);

    /**
     * 更新用户微信
     *
     * @param param
     * @return
     */
    Boolean updateByOpenid(ConsumerWechatUpdateParam param) throws BizException;

    /**
     * 查询用户微信信息
     *
     * @param openid
     * @return
     */
    ConsumerWechatDTO getDetailByOpenId(String openid);
}
