package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.ReceivingAddressOneParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.ReceivingAddressParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.ReceivingAddressDTO;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.ReceivingAddressQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 地址服务
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/28 2:29 下午
 **/
@AdvancedFeignClient
public interface RemoteReceivingAddressService {
    /**
     * 查询收货地址
     *
     * @param param
     * @return
     */
    PageResponse<ReceivingAddressDTO> queryForPage(ReceivingAddressQueryParam param);

    /**
     * 添加|修改收货地址
     *
     * @param param
     * @return
     */
    Boolean addOrUpdateAddress(ReceivingAddressParam param);

    /**
     * 获取默认的收货地址
     *
     * @param cid
     * @return
     */
    ReceivingAddressDTO getDefault(Long cid);

    /**
     * 查询收货地址信息
     *
     * @param param
     * @return
     */
    ReceivingAddressDTO getAddressDetail(ReceivingAddressOneParam param);

    /**
     * 删除地址
     *
     * @param param
     * @return
     */
    Boolean deleteAddress(ReceivingAddressOneParam param);

    /**
     * 统计地址
     * @param cid
     * @return
     */
    Long countAddress(Long cid);
}
