package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.AttrTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.GeneralTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.BaseDto;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.GeneralBiz;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/15 10:50 上午
 */
@Setter
@Getter
public class GoodsAttributeDto extends BaseDto implements Serializable, GeneralBiz {
    private static final long serialVersionUID = 1L;

    /**
     * 属性id
     */
    private Long attrId;
    /**
     * 属性名
     */
    private String attrName;
    /**
     * 属性值
     */
    private String attrValue;
    /**
     * 属性类型(1:参数属性,2:sku属性)
     *
     * @see AttrTypeEnum
     */
    private Integer attrType;
    /**
     * 排序
     */
    private Long sort;
    /**
     * 是否删除(0:未删除,1:已删除)
     */
    private Integer isDeleted;

    /**
     * spuID或skuID
     */
    private Long generalId;
    /**
     * 类型(1:spu;2:sku)
     *
     * @see GeneralTypeEnum
     */
    private Integer generalType;
}
