package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.GeneralTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.BaseDto;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.GeneralBiz;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.UserBiz;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;

/**
 * 图文详情
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/15 10:54 上午
 */
@Setter
@Getter
public class GoodsDetailDto extends BaseDto implements Serializable, GeneralBiz, UserBiz {
    private static final long serialVersionUID = 1L;

    /**
     * 卖点描述
     */
    public static final String JSON_SELLING_POINT = "sellingPoint";
    /**
     * 子标题
     */
    public static final String JSON_SUBTITLE = "subtitle";

    /**
     * 图文详情
     */
    public static final String JSON_DETAIL = "detail";

    /**
     * spuName或skuName
     */
    private String generalName;
    /**
     * spu详情或sku详情
     * 注意是json
     */
    private String detailContent;

    /**
     * @deprecated detailContent 是json格式 不应该直接调用
     */
    @Deprecated
    public String getDetailContent() {
        return detailContent;
    }

    /**
     * @deprecated detailContent 是json格式 不应该直接调用
     */
    @Deprecated
    public void setDetailContent(String detailContent) {
        this.detailContent = detailContent;
    }

    /**
     * 审核状态(1:正常,2:待审核,3:审核失败)
     */
    private Integer reviewStatus;


    /**
     * spuID或skuID
     */
    private Long generalId;
    /**
     * 类型(1:spu;2:sku)
     *
     * @see GeneralTypeEnum
     */
    private Integer generalType;

    /**
     * 快照Id
     */
    private String snapshotVersion;

    /**
     * 用户类型(1:平台;2:租户;3:用户)
     */
    private Integer userType;
    /**
     * 用户id
     */
    private Long userId;


    public String getSellingPoint() {
        return getJSONObject().getString(JSON_SELLING_POINT);
    }

    private JSONObject getJSONObject() {
        if (StringUtils.isNotBlank(detailContent) && JSONValidator.from(detailContent).validate()) {
            return JSONObject.parseObject(detailContent);
        }
        return new JSONObject();
    }

    public String getSubtitle() {
        return getJSONObject().getString(JSON_SUBTITLE);
    }

    public void setSubtitle(String subtitle) {
        JSONObject jsonObject = getJSONObject();
        jsonObject.put(JSON_SUBTITLE, subtitle);
        setDetailContent(jsonObject.toJSONString());
    }

    public String getDetail() {
        return getJSONObject().getString(JSON_DETAIL);
    }

    public void setDetail(String detail) {
        JSONObject jsonObject = getJSONObject();
        jsonObject.put(JSON_DETAIL, detail);
        setDetailContent(jsonObject.toJSONString());
    }

    public void setSellingPoint(String sellingPoint) {
        JSONObject jsonObject = getJSONObject();
        jsonObject.put(JSON_SELLING_POINT, sellingPoint);
        setDetailContent(jsonObject.toJSONString());
    }
}
