package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.DeleteFlagEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * 商品包装类
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/12 4:56 下午
 */
@Setter
@Getter
public class GoodsDto implements Serializable {
    private static final long serialVersionUID = 1L;

    private SpuDto spuDto;

    private List<SkuDto> skuList;

    public boolean selfGoods(CurTenantParam param) {
        return Objects.equals(getSpuDto().getUserId(), param.getCurUserId()) &&
                Objects.equals(getSpuDto().getUserType(), param.getCurUserType());
    }


    /**
     * 获取商品快照
     */
    public String getSnapshotVersion() {
        return Optional.ofNullable(getSpuDto()).map(SpuDto::getDetail).map(GoodsDetailDto::getSnapshotVersion).orElse(null);
    }

    /**
     * 判断商品是否被删除，支持供应商和租户
     */
    public boolean isDeleted() {
        return spuDto == null || Objects.equals(spuDto.getIsDeleted(), DeleteFlagEnum.DELETED.getIsDeleted())
                || spuDto.getDetail() == null;
    }
}
