package cn.com.duiba.cloud.duiba.goods.center.api.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

import java.util.Objects;

/**
 * 当前租户含义
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/8 1:52 下午
 */
@Getter
@Setter
public class CurTenantParam extends PageRequest {
    private static final long serialVersionUID = 2209398723528103578L;
    /**
     * 用户类型(1:平台;2:租户;3:用户)
     */
    private Integer curUserType;
    /**
     * 用户id
     */
    private Long curUserId;

    public CurTenantParam() {
    }

    public CurTenantParam(Integer curUserType, Long curUserId) {
        this.curUserType = curUserType;
        this.curUserId = curUserId;
    }

    /**
     * fixme 是否是当前用户的商品
     */
    public boolean hasUser() {
        return Objects.nonNull(curUserId) && Objects.nonNull(curUserType);
    }
}
