package cn.com.duiba.cloud.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.goods.GoodsDto;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsAuditParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsDetailParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsQueryParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsRemoveParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsSaveParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsSnapshotParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 商品管理端服务
 * 商品、图文、属性、分组
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/8 1:51 下午
 */
@AdvancedFeignClient
public interface RemoteGoodsService {


    /**
     * 仅保存/编辑商品，包含spu、sku、商品属性、图片、图文
     *
     * @return
     * @throws BizException
     */
    Long saveGoods(GoodsSaveParam param) throws BizException;


    /**
     * 审核商品
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean audit(GoodsAuditParam param) throws BizException;


    /**
     * 商品详情
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    List<GoodsDto> list(GoodsDetailParam param) throws BizException;


    /**
     * 列表查询
     *
     * @param goodsQueryParam
     *
     * @return
     * @throws BizException
     */
    PageResponse<GoodsDto> page(GoodsQueryParam goodsQueryParam) throws BizException;


    /**
     * 删除商品
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean remove(GoodsRemoveParam param) throws BizException;


    /**
     * 商品快照
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    GoodsDto snapshot(GoodsSnapshotParam param) throws BizException;
}
