package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.GeneralTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.channel.ItemChannelDto;
import cn.com.duiba.cloud.duiba.goods.center.api.util.GoodsSnapshotUtil;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Getter;
import lombok.Setter;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/8 1:47 下午
 */
@Getter
@Setter
public class SkuDto extends AbstractGoodsDto {
    private static final long serialVersionUID = 1L;
    /**
     * 商品id
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Long spuId;
    /**
     * sku编码
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private String skuCode;

    /**
     * 渠道库存相关
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private ItemChannelDto itemChannel;

    /**
     * spuID或skuID
     */
    @Override
    public Long getGeneralId() {
        return getId();
    }

    /**
     * /**
     * 类型(1:spu;2:sku)
     *
     * @see GeneralTypeEnum
     */
    @Override
    public Integer getGeneralType() {
        return GeneralTypeEnum.SKU.getGeneralType();
    }


}
