package cn.com.duiba.cloud.duiba.goods.center.api.param.attribute;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.AttributeTypeEnum;
import cn.com.duiba.wolf.entity.PageRequest;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

/**
 * 根据类目ID查询属性
 *
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class QueryAttributeByCategoryIdParam extends PageRequest {

    private static final long serialVersionUID = -3985091231281312064L;

    @NotNull(message = "类目ID不能为空")
    private Long categoryId;

    private Long attributeId;

    /**
     * 属性类型 {@link AttributeTypeEnum}
     */
    private Integer attrType;

    private String attributeName;

    private Integer attrState;

}
