package cn.com.duiba.cloud.duiba.goods.center.api.remoteservice;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.StatusEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.brand.BrandDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.brand.BrandCategoryRelDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.param.brand.BrandCategoryRelQueryParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.brand.BrandCreateParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.brand.BrandGetParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.brand.BrandUpdateParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 品牌管理服务
 *
 * @author hjw
 * @date 2021/11/8 1:51 下午
 */
@AdvancedFeignClient
public interface RemoteBranchService {


    /**
     * 根据名称模糊查询，品牌列表查询
     *
     * @param param 品牌名称- 分页获取
     * @return 品牌列表
     */
    PageResponse<BrandDTO> brandGet(BrandGetParam param) throws BizException;

    /**
     * 查询品牌详细数据
     *
     * @param brandId 品牌id (不可为空)
     * @return 品牌详情
     * @throws BizException
     */
    BrandDTO brandDetail(Long brandId) throws BizException;

    /**
     * 品牌修改
     *
     * @param param 品牌信息
     * @return 品牌详情
     */
    Boolean brandModify(BrandUpdateParam param) throws BizException;

    /**
     * 品牌创建
     *
     * @param param 品牌信息
     * @return 品牌id
     */
    Long brandCreate(BrandCreateParam param) throws BizException;

    /**
     * 品牌删除
     *
     * @param brandId 品牌id (不可为空)
     * @return 是否成功
     */
    Boolean brandDelete(Long brandId) throws BizException;

    /**
     * 品牌状态修改
     *
     * @param brandId 品牌id (不可为空)
     * @param status  状态值
     * @return 是否成功
     * @see StatusEnum 状态值取值范围
     */
    Boolean brandStatus(Long brandId, Integer status) throws BizException;

    /**
     * 根据类目id查询品牌
     *
     * @param param 类目id
     *
     * @return 品牌列表
     */
    PageResponse<BrandCategoryRelDTO> getBrandByCategoryId(BrandCategoryRelQueryParam param) throws BizException;
}
