package cn.com.duiba.cloud.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.goods.GoodsDto;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.goods.SimpleSkuDto;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsAuditParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsBatchSnapshotParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsDetailParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsQueryParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsRemoveParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsSaveParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsSnapshot;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 商品管理端服务
 * 商品、图文、属性、分组
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/8 1:51 下午
 */
@AdvancedFeignClient
public interface RemoteGoodsService {


    /**
     * 保存/编辑商品，包含spu、sku、商品属性、图片、图文
     * 内含库存渠道逻辑、快照逻辑
     *
     * @return
     * @throws BizException
     */
    Long saveGoods(GoodsSaveParam param) throws BizException;


    /**
     * 审核商品
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean audit(GoodsAuditParam param) throws BizException;


    /**
     * 商品详情:指定spu和sku
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    List<GoodsDto> list(GoodsDetailParam param) throws BizException;

    /**
     * 商品详情:指定sku
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    List<GoodsDto> listBySkuIds(GoodsDetailParam param) throws BizException;


    /**
     * 列表查询
     *
     * @param goodsQueryParam
     *
     * @return
     * @throws BizException
     */
    PageResponse<GoodsDto> page(GoodsQueryParam goodsQueryParam) throws BizException;


    /**
     * 删除商品
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean remove(GoodsRemoveParam param) throws BizException;

    /**
     * 批量获取商品快照
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    List<GoodsSnapshot> batchSnapshot(GoodsBatchSnapshotParam param) throws BizException;

    /**
     * 批量获取商品快照，为订单专门定制
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    List<SimpleSkuDto> batchSnapshot4OrderList(GoodsBatchSnapshotParam param) throws BizException;
}
