package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.GoodsSourceEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.param.CurTenantParam;
import cn.com.duiba.cloud.duiba.goods.center.api.util.GoodsSnapshotUtil;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * 商品包装类
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/12 4:56 下午
 */
@Setter
@Getter
public class GoodsDto implements Serializable {
    private static final long serialVersionUID = 1L;

    @JSONField(label = GoodsSnapshotUtil.LABEL_SNAPSHOT)
    private SpuDto spuDto;
    @JSONField(label = GoodsSnapshotUtil.LABEL_SNAPSHOT)
    private List<SkuDto> skuList;

    /**
     * 商品来源
     * 通过计算两个user得出
     *
     * @return cn.com.duiba.cloud.duiba.goods.center.api.constant.GoodsSource
     */
    public static GoodsSourceEnum getGoodsSource(GoodsDto goodsDto) {
        if (Objects.equals(goodsDto.getSpuDto().getUserType(), goodsDto.getSpuDto().getDetail().getUserType())
                && Objects.equals(goodsDto.getSpuDto().getUserId(), goodsDto.getSpuDto().getDetail().getUserId())) {
            return GoodsSourceEnum.OWN;
        }
        return GoodsSourceEnum.SUPPLIER;
    }


    /**
     * 是否是自己的商品
     *
     * @param param
     *
     * @return
     */
    public boolean selfGoods(CurTenantParam param) {
        return Objects.equals(this.getSpuDto().getUserId(), param.getCurUserId()) &&
                Objects.equals(this.getSpuDto().getUserType(), param.getCurUserType());
    }

    /**
     * 判断商品是否被删除，支持供应商和租户
     */
    public boolean isDeleted() {
        return spuDto == null || spuDto.getDetail() == null;
    }

    /**
     * 快照Id，商品之外的系统用
     */
    public String generateSnapshotId() {
        return GoodsSnapshotUtil.getSnapshotId(this);
    }


}
