package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;


import cn.com.duiba.cloud.duiba.goods.center.api.constant.GeneralTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.MediaTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.BaseDto;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.GeneralBiz;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.UserBiz;
import cn.com.duiba.cloud.duiba.goods.center.api.util.GoodsSnapshotUtil;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 媒体（图片、视频）
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/12 3:06 下午
 */
@Setter
@Getter
public class GoodsImageDto extends BaseDto implements Serializable, GeneralBiz, UserBiz {
    private static final long serialVersionUID = 1L;
    /**
     * 图片地址
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_TENANT)
    private String picUrl;
    /**
     * 图片类型
     *
     * @see MediaTypeEnum
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_TENANT)
    private Integer imgType;

    /**
     * 排序
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_TENANT)
    private Long sort;
    /**
     * 审核状态(1:正常,2:待审核,3:审核失败)
     */
    private Integer reviewStatus;

    /**
     * spuID或skuID
     */
    private Long generalId;
    /**
     * 类型(1:spu;2:sku)
     *
     * @see GeneralTypeEnum
     */
    private Integer generalType;

    /**
     * 用户类型(1:平台;2:租户;3:用户)
     */
    private Integer userType;
    /**
     * 用户id
     */
    private Long userId;


}
