package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.MediaTypeEnum;
import com.google.common.collect.Lists;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 基于skuId的商品信息，主要是给订单列表用
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/30 11:36
 */
@Setter
@Getter
public class SimpleSkuDto implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long spuId;
    private Long skuId;

    /**
     * 商品类型
     **/
    private Integer spuType;
    /**
     * 缩略图
     */
    private String smallImage;

    /**
     * 兑换项标题
     **/
    private String title;

    private List<SimpleAttributeDto> attr = new ArrayList<>();

    public SimpleSkuDto(GoodsDto goodsDto, Long skuId) {
        this();

        SpuDto spuDto = goodsDto.getSpuDto();
        setSpuId(spuDto.getId());
        setSkuId(skuId);
        setSpuType(spuDto.getSpuType());

        List<AbstractGoodsDto> abstractGoodsDtoList = Lists.newArrayList(spuDto);
        Optional<SkuDto> optional = goodsDto.getSkuList().stream().filter(skuDto -> Objects.equals(skuDto.getId(), skuId)).findFirst();
        if (optional.isPresent()) {
            SkuDto skuDto = optional.get();

            List<GoodsAttributeDto> attributeList = skuDto.getAttributeList();
            setAttr(attributeList.stream().map(SimpleAttributeDto::new).collect(Collectors.toList()));

            abstractGoodsDtoList.add(skuDto);
        }

        // 按顺序覆盖图片、名称
        for (AbstractGoodsDto abstractGoodsDto : abstractGoodsDtoList) {
            List<String> list = abstractGoodsDto.getImageByImageType(MediaTypeEnum.IMAGE_SMALL);
            if (CollectionUtils.isNotEmpty(list)) {
                setSmallImage(list.get(0));
            }

            String title = Optional.ofNullable(abstractGoodsDto.getDetail()).map(GoodsDetailDto::getGeneralName).orElse(null);
            if (StringUtils.isNotBlank(title)) {
                setTitle(title);
            }
        }

    }

    public SimpleSkuDto() {
    }
}
