package cn.com.duiba.cloud.duiba.goods.center.api.constant;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

import java.util.Objects;

/**
 * 商品来源
 * 计算得出
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/29 19:03
 */
@SuppressWarnings("AlibabaEnumConstantsMustHaveComment")
public enum GoodsSourceEnum implements IEnum<Integer> {
    OWN(1, "自有商品")
    /**
     * 兑吧也是供应商一员
     */
//    SUPPLIER(2, "供应商商品"),
    ;


    private final Integer code;
    private final String desc;

    GoodsSourceEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 获取code
     *
     * @return value()
     */
    @Override
    public Integer getDbCode() {
        return getCode();
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    /**
     * 商品来源
     * 通过计算两个user得出
     * 能操作商品的userType只能是租户，当不满足此条件时应另起方法
     *
     * @return cn.com.duiba.cloud.duiba.goods.center.api.constant.GoodsSource
     */
//    public static GoodsSourceEnum getGoodsSourceEnum(Long appId1, Long appId2) {
//        if (Objects.equals(appId1, appId2)) {
//            return GoodsSourceEnum.OWN;
//        }
//        return GoodsSourceEnum.SUPPLIER;
//    }
}
