package cn.com.duiba.cloud.duiba.goods.center.api.constant.sale;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

/**
 * 上架状态
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/4 12:00
 */
@SuppressWarnings("AlibabaEnumConstantsMustHaveComment")
public enum ShelfStatusEnum implements IEnum<Integer> {
    UN_SHELVE(0, "已下架/仓库中"),
    SHELVE(1, "已上架/供货中"),
    PART_SHELVE(3, "部分上架，SPU维度"),
    /**
     * 注意只有第一次选品的时候才是该状态，意义等于已下架
     * @deprecated 目前选品即上架，用不到
     */
    @Deprecated
    NEVER_SHELF(2, "未上架"),
    ;

    private final Integer shelfStatus;
    private final String desc;

    ShelfStatusEnum(Integer shelfStatus, String desc) {
        this.shelfStatus = shelfStatus;
        this.desc = desc;
    }

    public Integer getShelfStatus() {
        return shelfStatus;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 获取code
     *
     * @return value()
     */
    @Override
    public Integer getDbCode() {
        return getShelfStatus();
    }


    public Integer getShelfSwitch() {
        return this == UN_SHELVE || this == NEVER_SHELF ? 0 : 1;
    }

    public Integer getOnSale() {
        return this == UN_SHELVE || this == NEVER_SHELF ? 0 : 1;
    }

}
