package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.SnapshotTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.BaseDto;
import com.alibaba.fastjson.JSON;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/12/3 12:12
 */
@Setter
@Getter
public class GoodsSnapshotDto extends BaseDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 快照value
     */
    private String snapshotValue;

    /**
     * 商品Id
     */
    private Long spuId;

    /**
     * 租户Id/供应商Id
     */
    private Long appId;

    /**
     * 快照版本，等于spu.modified or detail.modified
     */
    private Date snapshotVersion;

    /**
     * 快照类型
     *
     * @see SnapshotTypeEnum
     */
    private Integer snapshotType;

    public GoodsSnapshotDto(Long spuId,
                            Long appId,
                            Date snapshotVersion,
                            SnapshotTypeEnum snapshotTypeEnum,
                            String snapshotValue) {
        this(spuId, appId, snapshotVersion, snapshotTypeEnum);
        setSnapshotValue(snapshotValue);

    }

    public GoodsSnapshotDto(Long spuId, Long appId, Date snapshotVersion, SnapshotTypeEnum snapshotTypeEnum) {
        this();
        setSpuId(spuId);
        setAppId(appId);
        setSnapshotVersion(snapshotVersion);
        setSnapshotType(snapshotTypeEnum.getSnapshotType());
    }

    public GoodsSnapshotDto() {
        super();
    }

    public void setSnapshotVersion(Date snapshotVersion) {
        this.snapshotVersion = new Date(snapshotVersion.getTime() / 1000 * 1000);
    }

    public static GoodsSnapshotDto convert(String snapshotId, SnapshotTypeEnum snapshotTypeEnum) {
        String[] split = snapshotId.split("_");
        return new GoodsSnapshotDto(Long.valueOf(split[0]), Long.valueOf(split[2]), new Date(Long.parseLong(split[1]) * 1000), snapshotTypeEnum);
    }

    public String getSnapshotId() {
        return String.format("%s_%s_%s_%s", spuId, getDateSecond(getSnapshotVersion()), appId, snapshotType);
    }

    private Long getDateSecond(Date snapshotVersion) {
        return snapshotVersion.getTime() / 1000;
    }
}
