package cn.com.duiba.cloud.duiba.goods.center.api.remoteservice.sale;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.sale.SaleDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.param.sale.*;

import java.util.List;

@AdvancedFeignClient
@SuppressWarnings("unused")
public interface RemoteSpuChannelService {

    /**
     * 保存渠道相关信息，是一个事务
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean saveSale(SaleSaveParam param) throws BizException;


    /**
     * 获取渠道信息
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    SaleDTO getBySpuIdAndAppId(SaleDetailParam param) throws BizException;


    /**
     * 通过spuId来更新Spu信息信息
     *
     * @param updateParam
     *
     * @return
     * @throws BizException
     */
    int updateSpuInfoBySpuId(SaleSpuInfoUpdateParam updateParam) throws BizException;


    /**
     * 全量读取 db 写入 es
     */
    void writeEs();


    /**
     * 删除商品
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean remove(SaleRemoveParam param) throws BizException;


    /**
     * 同步描述性的信息，并更新对应的 es
     *
     * @param param
     *
     * @return
     */
    Boolean syncDesc(GoodsDescSyncParam param) throws BizException;

    Boolean updateSale(SaleUpdateParam param) throws BizException;
}
