package cn.com.duiba.cloud.duiba.goods.center.api.constant;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/12/3 19:13
 */
@SuppressWarnings("AlibabaEnumConstantsMustHaveComment")
public enum SnapshotTypeEnum implements IEnum<Integer> {
    SUPPLIER(1, "供应商类型快照"),
    TENANT(2, "租户类型快照")
    ;

    private final Integer snapshotType;
    private final String desc;

    SnapshotTypeEnum(Integer snapshotType, String desc) {
        this.snapshotType = snapshotType;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 获取code
     *
     * @return value()
     */
    @Override
    public Integer getDbCode() {
        return getSnapshotType();
    }

    public Integer getSnapshotType() {
        return snapshotType;
    }
}
