package cn.com.duiba.cloud.duiba.goods.center.api.constant.sale;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/6 10:50
 */
@SuppressWarnings("AlibabaEnumConstantsMustHaveComment")
public enum ExpressTypeEnum implements IEnum<String> {
    FREE("free", "包邮"),
    unity("unity", "统一运费"),
    template("template", "运费模板"),
    ;

    private final String expressType;
    private final String desc;

    ExpressTypeEnum(String expressType, String desc) {
        this.expressType = expressType;
        this.desc = desc;
    }

    public String getExpressType() {
        return expressType;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 获取code
     *
     * @return value()
     */
    @Override
    public String getDbCode() {
        return getExpressType();
    }
}
