package cn.com.duiba.cloud.duiba.goods.center.api.constant.sale;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.Getter;

/**
 * 描述：上架类型，0-全部渠道，1-指定渠道
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/4/1 15:26
 */
@Getter
public enum ShelfTypeEnum implements IEnum<Integer> {
    ALL(0, "全部渠道"),
    CHANNEL(1, "指定渠道"),
    ;
    private final Integer shelfType;
    private final String desc;

    ShelfTypeEnum(Integer sourceType, String desc) {
        this.shelfType = sourceType;
        this.desc = desc;
    }


    @Override
    public Integer getDbCode() {
        return this.getShelfType();
    }
}
