package cn.com.duiba.cloud.duiba.goods.center.api.dto.sale;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.ExpressTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.BaseDto;
import lombok.Getter;
import lombok.Setter;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/6 10:50
 */
@Setter
@Getter
public class SpuExpressDTO extends BaseDto {
    private static final long serialVersionUID = 1L;

    /**
     * spuId
     */
    private Long spuId;

    /**
     * 待发货文案
     */
    private String expressAlertMessage;

    /**
     * 运费类型: free(包邮),unity(统一运费),template(运费模板)
     *
     * @see ExpressTypeEnum
     */
    private String expressType;

    /**
     * 运费价格:
     */
    private Long expressPrice;

    /**
     * 运费模板ID
     */
    private Long expressTemplateId;

    private String extraInfo;
}
