package cn.com.duiba.cloud.duiba.goods.center.api.param.sale;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.ExchangeSwitchEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.ShelfStatusEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.ShelfTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 选品参数
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/12 14:49
 */
@Setter
@Getter
public class SaleCopyParam extends CurTenantParam {
    private static final long serialVersionUID = 1L;

    @Valid
    @Size(min = 1, message = "选品列表不允许为空")
    private List<Item> list = new ArrayList<>();
    /**
     * 选品的上架状态，默认为下架
     * 1-上架  0-下架
     *
     * @see ShelfStatusEnum
     */
    @NotNull(message = "选品的上架状态不能为空")
    private Integer shelfStatus;


    /**
     * 选品模式
     * 其他-兑吧选品,1-积分商城选品
     */
    private Integer copyMode;

//    /**
//     * 选品方式，默认手动选品
//     */
//    private Integer sourceType = SourceTypeEnum.MANUAL.getSourceType();

    /**
     * 上架类型，默认全渠道上架
     */
    private Integer shelfType = ShelfTypeEnum.ALL.getShelfType();
    /**
     * 8位开关
     *
     * @see ExchangeSwitchEnum
     */
    private Integer exchangeSwitch = 0;


    @Setter
    @Getter
    public static class Item implements Serializable {
        private static final long serialVersionUID = 1L;
        @NotNull(message = "商品编码不允许为空")
        private Long spuId;
        @NotNull(message = "供应商编码不允许为空")
        private Long appId;
        /**
         * 修改类目，为空则不修改类目
         */
        private Long leafCategoryId;

        public Item(Long spuId, Long appId, Long leafCategoryId) {
            this.spuId = spuId;
            this.appId = appId;
            this.leafCategoryId = leafCategoryId;
        }

        public Item() {
        }
    }
}
