package cn.com.duiba.cloud.duiba.goods.center.api.param.sale;

import cn.com.duiba.cloud.duiba.goods.center.api.dto.sale.SkuChannelConfigDto;
import cn.com.duiba.cloud.duiba.goods.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 描述：
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/4/11 21:15
 */
@Setter
@Getter
public class ShelfChannelListParam extends CurTenantParam {
    private static final long serialVersionUID = 1L;

    @NotNull
    @Size(min = 1, max = 20)
    private List<Item> list = new ArrayList<>();

    @Setter
    @Getter
    public static class Item implements Serializable {
        private static final long serialVersionUID = 1L;

        @NotNull
        private Long skuId;
        @NotNull
        private Long channelId;
        /**
         * 这里是返回值，如果未配置，会返回一个默认值，
         */
        private SkuChannelConfigDto skuChannelConfigDto;

    }
}
