package cn.com.duiba.cloud.duiba.goods.center.api.param.sale;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.ShelfStatusEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.ShelfTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 分页查询spu列表请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022/1/4 3:23 下午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class TenantPageSpuParam extends PageSpuParam {
    private static final long serialVersionUID = 5626260601419137877L;

    /**
     * spuId
     */
    private Long spuId;
    private List<Long> spuIdList;

    /**
     * 租户的应用id
     */
    @NotNull(message = "应用id不能为空")
    private Long appId;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 类目id
     */
    private Long categoryId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 是否可用
     */
    private Integer isUsable;

    /**
     * 商品来源应用id
     */
    private List<Long> sourceAppIdList;

    /**
     * 上架状态(0:未上架/仓库中,1:已上架/供货中,3:部分上架)
     *
     * @see ShelfStatusEnum
     */
    private List<Integer> shelfStatusList;

    /**
     * 创建开始时间
     */
    private Date beginTime;

    /**
     * 创建结束时间
     */
    private Date endTime;

    /**
     * 供应商名称、编码
     */
    private String supplierName;
    private String supplierCode;

    /**
     * 商品编码
     */
    private String merchantCoding;


    /**
     * 商品编码（spu 维度）
     */
    private String spuCode;

    /**
     * 定向类型
     * null-全部  0-全部渠道 1-指定渠道
     *
     * @see ShelfTypeEnum
     */
    private Integer shelfType;


    /**
     * 排序模式
     * 0-默认排序 1-供货价降序 2-供货价升序 3-创建时间降序 4-创建时间升序
     */
    private Integer sortMode = 0;
}