package cn.com.duiba.cloud.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.coupon.CouponBatchDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.coupon.CouponBatchOverdueDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.coupon.CouponDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.coupon.CouponDetailDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.coupon.CouponExportDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.coupon.OrderCouponUseDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.coupon.SimpleCouponDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.CouponBindParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.CouponFindParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.CouponUseBySkuIdParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.DeleteCouponParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.DetailCouponParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.ImportCouponParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.InsertCouponCardParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.InsertCouponParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.IssueCouponParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.OrderCouponBatchParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.ProvideExternalCouponParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.UpdateCouponParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.UpdateReUseCouponCardParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @Description 卡券库相关
 * @Author dangcang
 * @Date 2022/3/15 5:59 下午
 **/
@AdvancedFeignClient
public interface RemoteCouponService {

    /**
     * 新增卡券
     *
     * @param param
     * @return 卡券批次信息
     * @throws BizException
     */
    CouponBatchDTO insert(InsertCouponParam param) throws BizException;


    /**
     * 新增券码
     *
     * @param params
     * @return
     */
    Boolean insertCouponCard(List<InsertCouponCardParam> params) throws BizException;

    /**
     * 卡券绑定skuId
     *
     * @param couponBindParam
     * @return
     */
    Boolean couponBinding(CouponBindParam couponBindParam);

    /**
     * 卡券解绑
     *
     * @param couponBindParam
     * @return
     */
    Boolean couponRelieve(CouponBindParam couponBindParam);

    /**
     * 查询卡券ById
     *
     * @param couponId
     * @return
     */
    CouponDTO findCouponById(Long couponId);

    /**
     * 异步任务失败时做删除卡券批次操作
     *
     * @param couponBatchId
     * @return
     */
    Boolean deleteCouponBatchByTaskError(Long couponBatchId);

    /**
     * 修改卡券
     *
     * @param param
     * @return
     * @throws BizException
     */
    Boolean update(UpdateCouponParam param) throws BizException;

    /**
     * 卡券分页查询列表
     *
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<CouponDTO> find(CouponFindParam param) throws BizException;

    /**
     * 卡券详情列表
     *
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<CouponDetailDTO> detail(DetailCouponParam param) throws BizException;

    /**
     * 卡券详情列表
     *
     * @param cardIds
     * @param couponId
     * @return
     * @throws BizException
     */
    List<CouponDetailDTO> findByCouponCardIds(List<Long> cardIds, Long couponId) throws BizException;

    /**
     * 卡券批次列表
     *
     * @param couponId
     * @return
     */
    List<CouponBatchDTO> findByCouponId(Long couponId);

    /**
     * 批次id获取卡券
     *
     * @param couponBatchIds
     * @return
     */
    List<CouponBatchDTO> findByCouponBatchId(List<Long> couponBatchIds);

    /**
     * 卡券详情
     *
     * @param couponCodeList
     * @param couponId
     * @return
     */
    List<CouponDetailDTO> findCouponDetailByCardInfo(List<String> couponCodeList, Long couponId);

    /**
     * 导入卡券信息
     *
     * @param param
     * @return
     * @throws BizException
     */
    CouponBatchDTO importCoupon(ImportCouponParam param) throws BizException;

    /**
     * 分配卡券 会减去相应可用数量及总数
     *
     * @param param
     * @return
     * @throws BizException
     */
    CouponBatchDTO issueCoupon(IssueCouponParam param) throws BizException;

    /**
     * 外发卡券
     *
     * @param param
     * @return
     * @throws BizException
     */
    CouponExportDTO provideExternal(ProvideExternalCouponParam param) throws BizException;

    /**
     * 删除券码
     *
     * @param param
     * @return
     * @throws BizException
     */
    Long delete(DeleteCouponParam param) throws BizException;

    /**
     * 订单使用卡券
     * todo 重复卡券消耗
     *
     * @param param
     * @return key skuId value 对应的券码信息
     */
    @Deprecated
    List<OrderCouponUseDTO> orderUseCoupon(OrderCouponBatchParam param) throws BizException;

    /**
     * 使用卡券 by skuId
     * @param param
     * @return
     * @throws BizException
     */
    OrderCouponUseDTO useCouponBySkuId(CouponUseBySkuIdParam param) throws BizException;

    /**
     * 定时删除批次库存查询接口
     * 默认一次最多返回500条
     *
     * @return
     */
    List<CouponBatchOverdueDTO> overdueDeleteCouponBatch();

    /**
     * 需要清空的批次id
     *
     * @param batchIds
     * @return
     */
    Boolean couponBatchReset(List<Long> batchIds);

    /**
     * 根据skuId列表获取卡券信息
     *
     * @param skuIds
     * @return
     */
    List<SimpleCouponDTO> findCouponBySkuIds(List<Long> skuIds);

    /**
     * 更新可重复使用卡密
     *
     * @param param
     * @return
     * @throws BizException
     */
    Boolean updateReuseCouponCard(UpdateReUseCouponCardParam param) throws BizException;
}