package cn.com.duiba.cloud.duiba.goods.center.api.openapi;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsDetailAppParam;
import cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenApi;
import cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenPath;
import cn.com.duiba.cloud.duiba.openapi.service.api.utils.OpenApiDocUtil;

import java.lang.reflect.Method;

/**
 * 商品开放接口，面向开放平台
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/21 13:53
 */
@OpenApi(prefix = "/goods")
@AdvancedFeignClient
public interface RemoteOpenGoodsService {

    /**
     * 条件化查询商品信息，支持跨appId
     *
     * @throws BizException
     */
    @OpenPath(apiPath = "/list", apiDesc = "批量条件化查询商品信息")
    GoodsDetailAppParam list(GoodsDetailAppParam param) throws BizException;

    /**
     * 在 {@link #list(GoodsDetailAppParam)}基础上支持按sku查询
     */
    @OpenPath(apiPath = "/list/by_sku_ids", apiDesc = "批量条件化查询商品信息，支持按sku查询")
    GoodsDetailAppParam listBySkuIds(GoodsDetailAppParam param) throws BizException;

    public static void main(String[] args) throws NoSuchMethodException {

        Method method = RemoteOpenGoodsService.class.getMethod("list", GoodsDetailAppParam.class);
        OpenApiDocUtil.createApiDoc(method);
        method = RemoteOpenGoodsService.class.getMethod("listBySkuIds", GoodsDetailAppParam.class);
        OpenApiDocUtil.createApiDoc(method);

    }
}
