package cn.com.duiba.cloud.duiba.goods.center.api.remoteservice;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.StatusEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.brand.CategoryBrandRelDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.category.CategoryDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.category.CategoryLeafRelDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.category.CategoryRelDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.param.category.CategoryBrandRelQueryParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.category.CategoryQueryParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.category.CategoryRelQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 品牌管理服务
 *
 * @author hjw
 * @date 2021/11/8 1:51 下午
 */
@AdvancedFeignClient
public interface RemoteCategoryService {


    /**
     * 创建一个类目
     *
     * @param parentCatId  如果是创建一级类目，那么请传0
     * @param sort         排序值
     * @param categoryName 类目名称
     * @return id
     * @throws BizException
     */
    Long createCategory(Long parentCatId, Integer sort, String categoryName) throws BizException;

    /**
     * 类目树查询
     *
     * @param categoryQueryParam@return
     */
    List<CategoryDTO> getCategoryTree(CategoryQueryParam categoryQueryParam);

    /**
     * 查询品牌下面的类目  分页查询
     *
     * @return
     * @throws BizException
     */
    PageResponse<CategoryBrandRelDTO> getCategoryByBrandId(CategoryBrandRelQueryParam categoryBrandRelQueryReyParam) throws BizException;

    /**
     * 交换两个类目的排序
     *
     * @param sourceId 源id
     * @param targetId 目标id
     * @return
     * @throws BizException
     */
    Boolean changeSort(Long sourceId, Long targetId) throws BizException;

    /**
     * 类目查询根据类目id,
     * 如果是叶子类目，那么返回叶子类目下的数据，
     * 如果不是，则返回下一级类目的数据
     *
     * @return 类目信息
     */
    PageResponse<CategoryRelDTO> getCategoryRelById(CategoryRelQueryParam param) throws BizException;

    /**
     * 关系删除
     *
     * @param relId 关系id
     * @return 操作结果
     */
    Boolean deleteRel(Long relId) throws BizException;

    /**
     * 删除类目
     *
     * @param categoryId 类目id
     * @return 操作结果
     * @throws BizException 如果校验不通过则抛出此异常
     */
    Boolean delete(Long categoryId) throws BizException;

    /**
     * 类目信息修改
     *
     * @param cateGoryId   类目id
     * @param categoryName l类目名称
     * @param status       状态枚举 {@link StatusEnum}
     * @return 操作结果
     * @throws BizException 如果校验不通过则抛出此异常
     */
    Boolean categoryModify(Long cateGoryId, String categoryName, Integer status) throws BizException;

    /**
     * 传入叶子类目id列表，获取他的类目关系
     * 注: 传入无效的类目id，以及非叶子类目id，返回结果不包含这些的处理
     *
     * @param leafCategoryIds 叶子类目关系
     * @return 叶子类目id以及对应的类目关系列表
     */
    List<CategoryLeafRelDTO> categoryRelationByLeafCatId(List<Long> leafCategoryIds);

    /**
     * 获取级联同名类目 例如 A->A->A 如果有哪一级类目不存在，则会创建（提供给林周使用）
     *
     * @param catName 类目名称
     * @return 叶子类目id
     */
    Long getCategoryIfNotExistCreate(String catName);
}
