package cn.com.duiba.cloud.duiba.goods.center.api.dto.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/3/15 6:19 下午
 **/
@Data
public class CouponDTO implements Serializable {

    private static final long serialVersionUID = 6701068821859434611L;
    /**
     * 卡券id
     */
    private Long couponId;

    /**
     * 卡券名称
     */
    private String couponName;

    /**
     * 卡券类型
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.CouponTypeEnum
     */
    private Integer couponType;

    /**
     * 卡券库类型
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.CouponLibraryEnum
     */
    private Integer couponLibraryType;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人名称
     */
    private Long createBy;

    /**
     * 卡券批次信息
     */
    private List<CouponBatchDTO> couponBatchDTOS;
}