package cn.com.duiba.cloud.duiba.goods.center.api.param.coupon;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/3/15 3:27 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class DetailCouponParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = -1114731884836279476L;
    /**
     * 使用状态 1-已使用 0-未使用
     */
    private Integer isUsed;

    /**
     * 卡券批次id
     */
    private Long couponBatchId;

    /**
     * 卡券id
     */
    @NotNull(message = "卡券id不能为空")
    private Long couponId;
}