package cn.com.duiba.cloud.duiba.goods.center.api.param.coupon;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/3/15 5:57 下午
 **/
@Data
public class InsertCouponParam implements Serializable {

    private static final long serialVersionUID = -3917127899286348583L;
    /**
     * 卡券名称
     */
    @NotBlank(message = "卡券名称不能为空")
    private String couponName;

    /**
     * 卡券类型
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.CouponTypeEnum
     */
    @NotNull(message = "卡券类型不能为空")
    private Integer couponType;

    /**
     * 卡券库类型CouponSaveParam
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.CouponLibraryEnum
     */
    @NotNull(message = "卡券库类型不能为空")
    private Integer couponLibraryType;

    /**
     * 开始有效期
     */
    @NotNull(message = "开始有效期不能为空")
    private Date startTime;

    /**
     * 结束有效期
     */
    @NotNull(message = "结束有效期不能为空")
    private Date endTime;

    /**
     * 券码文件地址
     */
    @NotBlank(message = "券码文件地址不能为空")
    private String filePath;

    /**
     * 创建人
     */
    @NotNull(message = "创建人id不能为空")
    private Long operationId;
}