package cn.com.duiba.cloud.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.coupon.CouponDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.coupon.CouponDetailDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.coupon.CouponOperationDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.CouponFindParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.DeleteCouponParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.DetailCouponParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.ExportCouponParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.ImportCouponParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.InsertCouponParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.IssueCouponParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.ProvideExternalCouponParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.coupon.UpdateCouponParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @Description 卡券库相关
 * @Author dangcang
 * @Date 2022/3/15 5:59 下午
 **/
@AdvancedFeignClient
public interface RemoteCouponService {

    /**
     * 新增卡券
     * @param param
     * @return 卡券id
     * @throws BizException
     */
    CouponOperationDTO insert(InsertCouponParam param) throws BizException;

    /**
     * 修改卡券
     * @param param
     * @return
     * @throws BizException
     */
    CouponOperationDTO update(UpdateCouponParam param) throws BizException;

    /**
     * 卡券分页查询列表
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<CouponDTO> find(CouponFindParam param) throws BizException;

    /**
     * 卡券详情列表
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<CouponDetailDTO> detail(DetailCouponParam param) throws BizException;

    /**
     * 导入卡券信息
     * @param param
     * @return
     * @throws BizException
     */
    CouponOperationDTO importCoupon(ImportCouponParam param) throws BizException;

    /**
     * 导出卡券信息 不会有变更操作
     * @param param
     * @return
     * @throws BizException
     */
    CouponOperationDTO exportCoupon(ExportCouponParam param) throws BizException;

    /**
     * 分配卡券 会减去相应可用数量及总数
     * @param param
     * @return
     * @throws BizException
     */
    CouponOperationDTO issueCoupon(IssueCouponParam param) throws BizException;

    /**
     * 外发卡券
     * @param param
     * @return
     * @throws BizException
     */
    CouponOperationDTO provideExternal(ProvideExternalCouponParam param) throws BizException;

    /**
     * 删除券码
     * @param param
     * @return
     * @throws BizException
     */
    CouponOperationDTO delete(DeleteCouponParam param) throws BizException;
}