package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.GeneralTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuStatusEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.SubSpuTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.UserBiz;
import cn.com.duiba.cloud.duiba.goods.center.api.param.CurTenantParam;
import cn.com.duiba.cloud.duiba.goods.center.api.util.GoodsSnapshotUtil;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Getter;
import lombok.Setter;

import java.util.Objects;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/8 1:36 下午
 */
@Getter
@Setter
public class SpuDto extends AbstractGoodsDto implements UserBiz {
    private static final long serialVersionUID = 1L;
    /**
     * 品牌id
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Long brandId;
    /**
     * 商品类型(1:实物,2:优惠券:3:充值,4:权益)
     *
     * @see SpuTypeEnum
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Integer spuType;

    /**
     * 商品子类型
     * @see SubSpuTypeEnum
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Integer subSpuType;
    /**
     * 应用Id
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Long appId;

    /**
     * 创建员工Id
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Long staffId;

    /**
     * 商品状态(1:正常商品, 2:草稿箱商品, 3:审核中,4:审核失败)
     *
     * @see SpuStatusEnum
     */
    private Integer spuStatus;
    /**
     * 叶子类目
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Long leafCategoryId;


    /**
     * 该spu下sku属性拼接
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private String attributeKey;

    /**
     * 商品编码
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private String spuCode;
    /**
     * 供应商编码
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private String supplerName;
    /**
     * 供应商名称
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private String supplerCode;



    /**
     *  0-是否存在跳转
     */
    private Boolean haveJumpLink;

    /**
     * 1-是否展示卡券条形码
     */
    private Boolean showCouponCode;

    /**
     * 2-是否需要填写账号信息
     */
    private Boolean needFillAccount;

    /**
     * 3-是否延迟发货、稍后发货、接口发券
     */
    private Boolean deliverLater;

    /**
     * spuID或skuID
     */
    @Override
    public Long getGeneralId() {
        return getId();
    }

    /**
     * /**
     * 类型(1:spu;2:sku)
     *
     * @see GeneralTypeEnum
     */
    @Override
    public Integer getGeneralType() {
        return GeneralTypeEnum.SPU.getGeneralType();
    }

    public boolean selfSpu(CurTenantParam param) {
        return Objects.equals(this.getAppId(), param.getCurAppId());
    }
}
