package cn.com.duiba.cloud.duiba.goods.center.api.param.coupon;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/3/15 2:12 下午
 **/
@Data
public class ImportCouponParam implements Serializable {

    private static final long serialVersionUID = -4448006767313457327L;
    /**
     * 卡券id
     */
    @NotNull(message = "卡券id不能为空")
    private Long couponId;

    /**
     * 当前操作人id
     */
    @NotNull(message = "当前操作人不能为空")
    private Long operatorId;

    /**
     * 卡券批次id
     */
    private Long couponBatchId;

    /**
     * 有效期开始时间
     */
    private Date startTime;

    /**
     * 有效期截止时间
     */
    private Date endTime;
}