package cn.com.duiba.cloud.duiba.goods.center.api.openapi;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsDetailAppParam;

/**
 * 商品开放接口，面向开放平台
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/21 13:53
 */
@AdvancedFeignClient
public interface RemoteOpenGoodsService {

    /**
     * 条件化查询商品信息，支持跨appId
     *
     * @throws BizException
     */
    GoodsDetailAppParam list(GoodsDetailAppParam param) throws BizException;

    /**
     * 在 {@link #list(GoodsDetailAppParam)}基础上支持按sku查询
     */
    GoodsDetailAppParam listBySkuIds(GoodsDetailAppParam param) throws BizException;
}
