package cn.com.duiba.cloud.duiba.goods.center.api.param.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/25 11:00
 */
@Setter
@Getter
public class GoodsSnapshotSaveParam extends CurTenantParam {
    private static final long serialVersionUID = 1L;

    private List<GoodsSnapshotSaveParam.Item> itemList = new ArrayList<>();

    @Setter
    @Getter
    public static class Item implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long spuId;
        /**
         * 租户信息，appId为空则会使用供应商信息
         */
        private Long appId;

        public Item(Long spuId, Long appId) {
            this.spuId = spuId;
            this.appId = appId;
        }

        public Item() {
        }
    }
}
