package cn.com.duiba.cloud.duiba.goods.center.api.param.coupon;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/3/15 6:03 下午
 **/
@Data
public class UpdateCouponParam implements Serializable {

    private static final long serialVersionUID = -4634050686511659571L;
    /**
     * 卡券id
     */
    @NotNull(message = "卡券id不能为空")
    private Long couponId;

    /**
     * 当前操作人id
     */
    @NotNull(message = "当前操作人不能为空")
    private Long operatorId;

    /**
     * 卡券名称
     */
    @NotBlank(message = "卡券名称不能为空")
    private String couponName;

    /**
     * 卡券批次id
     */
    @NotNull(message = "卡券批次id不能为空")
    private Long couponBatchId;

    /**
     * 结束有效期
     */
    @NotNull(message = "结束有效期不能为空")
    private Date endTime;

    /**
     * 可操作人列表
     */
    @NotEmpty(message = "可操作人列表不能为空")
    private List<Long> operationalPeople;
}