package cn.com.duiba.cloud.duiba.goods.center.api.param.coupon;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description 更新可重复使用卡券
 * @Author dangcang
 * @Date 2022/3/25 6:10 下午
 **/
@Data
public class UpdateReUseCouponCardParam implements Serializable {

    private static final long serialVersionUID = 3015292796026111375L;

    /**
     * 卡券id
     */
    @NotNull(message = "卡券id不能为空")
    private Long couponId;

    /**
     * 卡券批次id
     */
    @NotNull(message = "卡券批次不能为空")
    private Long couponBatchId;

    /**
     * + 加库存
     * - 加库存
     */
    @NotNull(message = "操作卡券数量")
    private Integer optNum;

    /**
     * 券码
     */
    @NotBlank(message = "券码不能为空")
    private String cardNo;

    /**
     * 卡密
     */
    private String cardPassword;

    /**
     * 操作人
     */
    @NotNull(message = "操作人不能为空")
    private Long operatorId;
}