package cn.com.duiba.cloud.duiba.goods.center.api.constant;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.Getter;

/**
 * 描述：商品子类型
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/3/29 13:44
 */
@Getter
public enum SubSpuTypeEnum implements IEnum<Integer> {
    // 实物、充值
    NONE(0, "无细化"),
    // 以下是卡券类型
    COUPON(1, "普通卡券"),
    CRYPTO_CARD(2, "卡密券"),
    LINK_CARD(3, "链接券"),
    ;
    private final Integer subSpuType;
    private final String desc;

    SubSpuTypeEnum(Integer subSpuType, String desc) {
        this.subSpuType = subSpuType;
        this.desc = desc;
    }

    @Override
    public Integer getDbCode() {
        return getSubSpuType();
    }
}
