package cn.com.duiba.cloud.duiba.goods.center.api.param.coupon;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/3/15 2:05 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class CouponFindParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = -1710126714025772234L;

    /**
     * 卡券id
     */
    private Long couponId;

    /**
     * 卡券id列表
     */
    private List<Long> couponIds;

    private List<Long> skuIds;

    private Long spuId;

    /**
     * 应用id
     */
    @NotNull(message = "应用id不能为空")
    private Long appId;

    /**
     * 卡券名称
     */
    private String couponName;

    /**
     * 卡券库类型
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.CouponLibraryEnum
     */
    private Integer couponLibraryType;

    /**
     * 卡券类型
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.CouponTypeEnum
     */
    private Integer couponType;

    /**
     * 创建时间 时间戳
     */
    private Date createStartTime;

    /**
     * 创建时间 时间戳
     */
    private Date createEndTime;


    /**
     * 0-create desc 大-》小
     * 1-create asc 小-》大
     */
    private Integer orderByType;

    /**
     * 1-可重复使用
     * 2-不可重复使用
     */
    private Integer reuse;

    /**
     * 新建卡券商品查询时需要改为true
     */
    private Boolean binding = Boolean.FALSE;

    /**
     * 是否需要重复卡券的卡券信息
     */
    private Boolean needRepeatCoupon = Boolean.FALSE;

}