package cn.com.duiba.cloud.duiba.goods.center.api.param.coupon;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Set;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/3/31 3:20 下午
 **/
@Data
public class OrderCouponBatchParam implements Serializable {

    private static final long serialVersionUID = -831871985650304283L;
    /**
     * 领取的appId
     */
    @NotNull(message = "领取应用id不能为空")
    private Long useAppId;

    /**
     * 领取人id
     */
    @NotNull(message = "领取人id不能为空")
    private Long userId;

    /**
     * 消耗skuId参数，会对skuId做Map，不要传重复的skuId
     */
    @NotEmpty(message = "消耗参数不能为空")
    @Valid
    private Set<OrderCouponUseParam> couponUseParams;
}