package cn.com.duiba.cloud.duiba.goods.center.api.param.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.dto.goods.GoodsDto;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/18 13:39
 */
@Setter
@Getter
public class GoodsDetailAppParam implements Serializable {
    private static final long serialVersionUID = 1L;

    private List<GoodsDetailAppParam.Item> itemList = new ArrayList<>();

    // 条件化查询
    private Boolean needSku = true;
    private Boolean needImage = true;
    private Boolean needDetail = true;
    private Boolean needAttribute = true;
    /**
     * 是否要获取 sku 关联的卡券
     */
    private Boolean needCoupon = Boolean.FALSE;
    /**
     * 如果没有租户信息，是否用供应商的商品信息替换
     */
    private Boolean replaceIfAbsent = true;

    @Setter
    @Getter
    public static class Item implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long spuId;
        private Long skuId;
        /**
         * 租户信息，appId为空则会返回供应商信息
         */
        private Long appId;

        /**
         * 不用传
         */
        private Long supplierAppId;

        /**
         * 返回的结果
         */
        private GoodsDto goodsDto;

        public Item(Long spuId, Long appId) {
            this.spuId = spuId;
            this.appId = appId;
        }

        public Item() {
        }
    }
}
