package cn.com.duiba.cloud.duiba.http.client.bo;


import cn.com.duiba.cloud.duiba.http.client.context.body.FileBody;
import cn.com.duiba.cloud.duiba.http.client.context.form.Form;
import cn.com.duiba.cloud.duiba.http.client.context.header.HttpHeader;
import cn.com.duiba.cloud.duiba.http.client.context.url.Url;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

/**
 * http请求参数存储类
 *
 * @author linzhou
 */
public class HttpClientRequest {

    /**
     * 表单格式的参数键值对
     */
    private List<Form> forms = new ArrayList<>();
    /**
     * 自定义的请求头
     */
    private HttpHeader httpHeader = new HttpHeader();
    /**
     * body形式的数据
     */
    private String body = null;
    /**
     * 需要上传的文件
     */
    private List<FileBody> uploadFiles = new ArrayList<>();
    /**
     * 指定url
     */
    private Url httpUrl;

    public void addFrom(Form nameValueParam) {
        if (nameValueParam != null) {
            forms.add(nameValueParam);
        }
    }

    public HttpHeader getHttpHeader() {
        if (httpHeader != null) {
            return httpHeader;

        } else {
            return new HttpHeader();
        }
    }

    public void setHttpHeader(HttpHeader httpHeader) {
        this.httpHeader = httpHeader;
    }

    public void addHttpHeader(HttpHeader httpHeader) {
        if (Objects.isNull(this.httpHeader)){
            this.httpHeader = httpHeader;
        }else {
            this.httpHeader.addHeader(httpHeader);
        }
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public List<FileBody> getUploadFiles() {
        return uploadFiles;
    }

    public void setUploadFiles(List<FileBody> uploadFiles) {
        this.uploadFiles = uploadFiles;
    }

    public void setUploadFile(FileBody uploadFile) {
        if (Objects.nonNull(uploadFile)) {
            this.uploadFiles.add(uploadFile);
        }
    }

    public List<Form> getForms() {
        return forms;
    }

    public void setForms(List<Form> forms) {
        this.forms = forms;
    }

    public Url getHttpUrl() {
        return httpUrl;
    }

    public void setHttpUrl(Url httpUrl) {
        this.httpUrl = httpUrl;
    }

    public void addMethodParams(Collection<?> methodParams) {
        if (CollectionUtils.isNotEmpty(methodParams)) {
            for (Object methodParam : methodParams) {
                addMethodParam(methodParam);
            }
        }
    }

    public void addMethodParam(Object methodParam) {
        if (methodParam instanceof Collection) {
            addMethodParams((Collection<?>) methodParam);
        } else if (methodParam instanceof Form) {
            //处理表单参数
            addFrom((Form) methodParam);
        } else if (methodParam instanceof FileBody) {
            //处理文件上传
            setUploadFile((FileBody) methodParam);
        } else if (methodParam instanceof HttpHeader) {
            //设置请求头
            httpHeader.addHeader((HttpHeader) methodParam);
        } else if (methodParam instanceof Url) {
            //处理自定义url
            setHttpUrl((Url) methodParam);
        } else {
            //处理body
            setBody((String) methodParam);
        }
    }
}
