package cn.com.duiba.cloud.duiba.http.client.handler.analysis.method.impl.body;

import cn.com.duiba.cloud.duiba.http.client.handler.analysis.method.AnalysisMethodParamHandler;
import com.alibaba.fastjson.JSON;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.lang.annotation.Annotation;

/**
 *
 * @date : 2021/12/12 15:36
 * @author: linzhou
 * @description : 默认的body处理器
 */
@Component
@Order
public class BodyHandler implements AnalysisMethodParamHandler {
    @Override
    public Object analysisMethodParam(Object param, Annotation[] annotations) throws Exception {
        return getBody(param);
    }

    /**
     * 处理body
     *
     * @param arg
     * @return
     */
    private String getBody(Object arg) {
        String body;
        if (arg instanceof String) {
            body = (String) arg;
        } else {
            body = JSON.toJSONString(arg);
        }
        return body;
    }
}
